// ew
import openfl.Lib;
import openfl.system.Capabilities;
import flixel.system.scaleModes.RatioScaleMode;
import lime.graphics.Image;
import funkin.backend.utils.WindowUtils;
import funkin.editors.ui.UIState;
import funkin.backend.utils.HttpUtil;
import funkin.backend.system.Logs;

static var initialized:Bool = false;
public static var isDone:Bool = false;
public static var fromSearchState:Bool = false;
public static var searchStateEntry:String = "song";

// width 'n height
function resize(w, h) {
	FlxG.scaleMode = new RatioScaleMode();
	FlxG.initialWidth = FlxG.width = w;
	FlxG.initialHeight = FlxG.height = h;
	FlxG.resizeWindow(w, h);
	Lib.application.window.x = Std.int((Capabilities.screenResolutionX / 2) - (Lib.application.window.width / 2));
	Lib.application.window.y = Std.int((Capabilities.screenResolutionY / 2) - (Lib.application.window.height / 2));
}

resize(960, 720);
function destroy() {
	resize(1280, 720);
	WindowUtils.resetTitle();
}

var redirectStates:Map<FlxState, String> = [
	TitleState => "customStates/YTPTitleState",
	MainMenuState => "customStates/YTPMainMenuState",
	StoryMenuState => "customStates/YTPStoryMenuState",
];

function preStateSwitch() {
	// trace("State is PlayState ? " + (FlxG.game._state is PlayState));
	// trace("Requested is FPlay ? " + (FlxG.game._requestedState is FreeplayState));
	// trace("fromSearchState yes? " + fromSearchState);

	if (FlxG.save.data.hatenaDone && !FlxG.save.data.graspDone && !FlxG.save.data.daweegeeCursedMenu) {
		FlxG.game._requestedState = new ModState('customStates/DaweegeeVideo');
	} else if (FlxG.save.data.graspDone && !FlxG.save.data.tyPopupHappen) {
		FlxG.game._requestedState = new ModState('customStates/YTPMainMenuState');
	} else {
		for (redirectState in redirectStates.keys())
			if (FlxG.game._requestedState is redirectState)
				FlxG.game._requestedState = new ModState(redirectStates.get(redirectState));
	}

	if (
		(FlxG.game._state is PlayState)					// check: current state is PlayState?
		&& (FlxG.game._requestedState is FreeplayState)	// check: state we're going to is Freeplay?
		&& fromSearchState								// check: entered the song via the Search state?
		) {
		fromSearchState = false;
		FlxG.game._requestedState = new UIState(true, "customStates/SearchMenuState");
		FlxG.sound.music.play(Paths.music("freakyMenu"));
	}

	FlxG.camera.bgColor = 0xFF000000;
	window.frameRate = Options.framerate;
	WindowUtils.winTitle = window.title = FlxG.save.data.daweegeeCursedMenu ? "01011001 01010100 01010000 00100000 01001001 01001110 01010110 01000001 01011010 01001001 01001111 01001110" : "Friday Night Funkin': YTP Invasion";
	window.setIcon(Image.fromBytes(Assets.getBytes(Paths.image('game/icon'))));
}

// temporary
// pls dont leave these uncommented after using them or ill cry ~abyss
function update(elapsed) {
	// if (FlxG.keys.justPressed.Q)
	//	FlxG.switchState(new TitleState());
	// if (FlxG.keys.justPressed.R)
	//	FlxG.switchState(new UIState(true, "customStates/SearchMenuState"));
}
